//
// (c) wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2

import wesual.data.Core 1.0
import wesual.Controls 1.0

Item {
    id : dragItem

    default property Component content : defaultContent

    readonly property Item view : {
        // Delegate may be used in either a ListView or GridView
        if (ListView && ListView.view) {
            return ListView.view;
        } else if (GridView && GridView.view) {
            return GridView.view;
        }

        throw new Error("Failed to obtain the containing view");
    }

    readonly property bool isDragged : p_.isDragged
    signal dragStarted()

    property Document sourceDoc : document

    QtObject {
        id : p_
        property bool isDragged : false
        property Item draggable
    }

    Component {
        id : defaultContent

        Rectangle {
           width : 100
           height : 100
       }
    }

    width : 100
    height : 100
    opacity : 1

    function instanceDraggable() {
        var draggable = draggableTemplate.createObject(dragItem, {
            "document" : document,
            "originatingView" : dragItem.view
        });
        content.createObject(draggable);
        p_.draggable = draggable;
    }

    onSourceDocChanged  : {
        if (p_.draggable) // Model DataChanged fix to assign new Doc to draggable
            p_.draggable.document = sourceDoc;
    }

    Component.onCompleted : instanceDraggable()

    Component {
        id : draggableTemplate

        Draggable {
            id : draggable

            property Document document
            property Item     originatingView
            property int      originatingIndex

            transformOrigin : Item.Center
            Behavior on scale {
                NumberAnimation {
                    duration: 200
                    easing.type: Easing.InOutQuad
                }
            }

            width : dragItem.width
            height : dragItem.height

            anchors.horizontalCenter : parent.horizontalCenter
            anchors.verticalCenter : parent.verticalCenter

            dragData : "we.captivo.DragDelegate"

            onIsDraggedChanged : p_.isDragged = isDragged;
            onDragStarted : {
                try {
                    document.beginRecordChanges();
                    detach();
                } catch (e) {
                    console.error(e.message);
                }
                dragItem.dragStarted();
            }

            NumberAnimation {
                id : discardAnimation
                target : draggable
                duration : 200
                property : "opacity"
                to : 0
                alwaysRunToEnd : true
                onStopped : draggable.destroy();
            }

            function detach() {
                anchors.verticalCenter = undefined;
                anchors.horizontalCenter = undefined;

                originatingIndex = index;

                var dragRoot = parent;
                while (dragRoot.parent) {
                    dragRoot = dragRoot.parent;
                }

                parent = dragRoot;

                // Intentionally connect after reparenting the item to avoid
                // corner cases that prevent the signal from being delivered
                draggable.onDragEnded.connect(discard);

                dragItem.instanceDraggable();
            }

            function discard() {
                document.endRecordChanges();
                enabled = false;
                discardAnimation.start();
            }
        }
    }
}
